# Sciencéthic

# Lecture d'un capteur de température analogique sur le port A1.
# -> Schéma de câblage de ce capteur en bas de page

# Le capteur de température utilisé  Réf.651 054 : CTN 10K ETANCHE

from math import log
from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
#
brocheCapteurCTN = plugUno.get_pin('a:1:i')
# -> a  : signifie mode analogique
# -> 1  : numéro de la broche
# -> i  : mode entrée

# Active le mécanisme de rapport d'état des E/S
plugUno.samplingOn()

# Patienter un peu permet d'obtenir une première lecture cohérente de A1.
sleep(0.1)

################################
# Section mesures
################################
poursuite=True
while poursuite:
    
    # lecture de la valeur sur la broche A0
    # calcul de la tension aux bornes de la résistance R1
    U= 5 * brocheCapteurCTN.read()

    # calcul la résistance de la thermistance
    R=10000*(5-U)/U

    # calcul de la temperature à partir de la courbe d'étalonnage sur tableur
    temperature=-26.04*log(R)+265.26

    # affichage de la valeur mesurée arrondie
    print('température =',round(temperature,1),'°C')
    
    if input('Déclencher une nouvelle mesure (oui/non) ? ') == "non" : poursuite=False

# fermeture de la communication sur le port
plugUno.exit()                                         


####################################
# Schéma de câblage du capteur CTN
####################################
'''
VCC 5V (nominal)
   _ _
    |
    |
    <    Rctn
    >    10 K Ohm
    <    @ 25 °C        
    |
    |-------------< SIG
    |
    <
    >    R1
    <    10 K Ohm
    |
   _|_
    -
    GND

'''

